<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is specific to AIX Patch Checks of SCAP Content.
        
        Patch details will be piacked up based on the result of the applicability. 
        
        Usual title pattern would be Patch for AIX <cause of the vulnerability> vulnerability.
        
        Example:Patch for AIX named DNS BIND dynamic update denial of service vulnerability
        
        This library is in specific for OpenSSL
        Affected fileset is verified for a version >= vulnerable version and < a fixed version.
        
        <criteria operator="AND">
            <criterion comment="openssl.base fileset existence test" test_ref="oval:com.mcafee.oval:tst:232415"/> - Applicability test (fileset existence test)
            <criterion comment="Check if openssl.base fileset version is greater than or equal to 1.0.1.500" test_ref="oval:com.mcafee.oval:tst:416194"/> - fileset version >= vulnerable version
            <criterion comment="Check if openssl.base fileset version is less than 1.0.1.502" test_ref="oval:com.mcafee.oval:tst:1234"/> - fileset version < fixed version
        </criteria>
                            
	Test Cases:
	1. Pass - Not Applicable - When OpenSSL is not installed (required fileset is not present) on the system.
	2. Pass - Not Applicable - fileset version of OpenSSL installed on the system is not vulnerable. 
	3. Pass - Fixed version of OpenSSL is installed on the system (Installed version >= Fixed version). 
	4. Fail - Vulnerable version of OpenSSL is installed on the system
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="appTestRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="appVerRangeRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[2]/@result"/>
        
        <xsl:variable name="expectedVer">
            <xsl:for-each select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state">
                <xsl:if test="aix-def:level/@operation='less than'">
                    <xsl:value-of select="aix-def:level/text()"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test/@id"/>
        <xsl:variable name="fileTestItem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileTest_id]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fileset_item[@id=$fileTestItem_id]" />        
        <xsl:variable name="actualVer" select="$fileTestItem/aix-sc:level/text()"/>
        
        <xsl:variable name="objID" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$fileTest_id]/descendant::aix-def:object/@object_ref"/>
        <xsl:variable name="filesteName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object[@id=$objID]/aix-def:flstinst/text()"/>
        
        <xsl:variable name="title">
            <xsl:value-of select="substring-after(/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title,'Patch for ')"/>            
        </xsl:variable>
        <xsl:variable name="product">
            <xsl:text>OpenSSL</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                 <xsl:text>com.mcafee.pa.msg.aixAppVerNotInstalled</xsl:text>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$actualVer!='' and $appVerRangeRes='true'">
                        <xsl:text>com.mcafee.pa.msg.aixAppVerInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$actualVer!='' and $appVerRangeRes='false'">
                        <xsl:text>com.mcafee.pa.msg.aixAppVerNotVulnerable</xsl:text>
                    </xsl:when>
                    <xsl:when test="$appTestRes='false'">
                        <xsl:text>com.mcafee.pa.msg.aixAppVerNotApplicable</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">expectedValue</xsl:attribute>
                <xsl:value-of select="$expectedVer" />
            </xsl:element>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">vulnerability</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">product</xsl:attribute>
                    <xsl:value-of select="$product"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">fileset</xsl:attribute>
                    <xsl:value-of select="$filesteName"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualValue</xsl:attribute>
                    <xsl:value-of select="$actualVer"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>