<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">

    <!--
    
    	This XSLT is used to verify the certain audit policy setting against user input.
    	
        Criterio (and)
    	        citerion family test or extend def
    	        criterion  audit policy  test
            
                      <account_logon>AUDIT_SUCCESS</account_logon>
	        <account_management>AUDIT_NONE</account_management>
	        <detailed_tracking>AUDIT_NONE</detailed_tracking>
	        <directory_service_access>AUDIT_NONE</directory_service_access>
	        <logon>AUDIT_SUCCESS</logon>
	        <object_access>AUDIT_NONE</object_access>
	        <policy_change>AUDIT_NONE</policy_change>
	        <privilege_use>AUDIT_NONE</privilege_use>
    		<system>AUDIT_NONE</system>
                
        
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>

    <!--<account_logon>AUDIT_SUCCESS</account_logon>
    <account_management>AUDIT_NONE</account_management>
    <detailed_tracking>AUDIT_NONE</detailed_tracking>
    <directory_service_access>AUDIT_NONE</directory_service_access>
    <logon>AUDIT_SUCCESS</logon>
    <object_access>AUDIT_NONE</object_access>
    <policy_change>AUDIT_NONE</policy_change>
    <privilege_use>AUDIT_NONE</privilege_use>
    <system>AUDIT_NONE</system>
-->
    <xsl:template name="getMessageId">
        <xsl:param name="eventname"/>

        <xsl:choose>
            <xsl:when test="$eventname = 'account_logon'  ">
                <xsl:text>com.mcafee.pa.msg.winaccountlogoneventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'account_management'  ">
                <xsl:text>com.mcafee.pa.msg.winaccountmanagementeventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'directory_service_access'  ">
                <xsl:text>com.mcafee.pa.msg.windirectoryserviceaccesseventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'logon'  ">
                <xsl:text>com.mcafee.pa.msg.winlogoneventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'object_access'  ">
                <xsl:text>com.mcafee.pa.msg.winobjectaccesseventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'policy_change'  ">
                <xsl:text>com.mcafee.pa.msg.winpolicychangeeventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'privilege_use'  ">
                <xsl:text>com.mcafee.pa.msg.winprivilegeuseeventsetting</xsl:text>
            </xsl:when>

            <xsl:when test="$eventname = 'system'  ">
                <xsl:text>com.mcafee.pa.msg.winsystemeventsetting</xsl:text>
            </xsl:when>
            <xsl:when test="$eventname = 'detailed_tracking'  ">
                <xsl:text>com.mcafee.pa.msg.windetailedtrackingeventsetting</xsl:text>
            </xsl:when>
        </xsl:choose>

    </xsl:template>

    <!--<possible_value hint="Failure only">AUDIT_FAILURE</possible_value>
    <possible_value hint="Success only">AUDIT_SUCCESS</possible_value>
    <possible_value hint="Success and Failure">AUDIT_SUCCESS_FAILURE</possible_value>
    <possible_value hint="None">AUDIT_NONE</possible_value>
    -->

    <xsl:template name="auditString">
        <xsl:param name="auditType"/>
        <xsl:choose>
            <xsl:when test="$auditType = 'AUDIT_FAILURE' ">
                <xsl:text>Failure (AUDIT_FAILURE)</xsl:text>
            </xsl:when>
            <xsl:when test="$auditType = 'AUDIT_SUCCESS' ">
                <xsl:text>Successful (AUDIT_SUCCESS)</xsl:text>
            </xsl:when>
            <xsl:when test="$auditType = 'AUDIT_SUCCESS_FAILURE' ">
                <xsl:text>Failure and Successful (AUDIT_SUCCESS_FAILURE)</xsl:text>
            </xsl:when>
            <xsl:when test="$auditType = 'AUDIT_NONE' ">
                <xsl:text>None (AUDIT_NONE)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Unknown</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>


       <xsl:call-template name="winAuditEventCheck">
           <xsl:with-param name="definitionId" select="$definitionId"/>
       </xsl:call-template>


    </xsl:template>

    <xsl:template name="winAuditEventCheck">
        <xsl:param name="definitionId"/>

        <xsl:variable name="tests">
            <xsl:for-each
                select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:auditeventpolicy_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:auditeventpolicy_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:auditeventpolicy_test[@id=$test]/win-def:state/@state_ref"/>

                    <!--<xsl:variable name="auditpolicy_parameter">
                        <xsl:for-each select="$States/win-def:auditeventpolicy_state[@id=$state]/*">
                            <xsl:if test="position()=1">
                                <xsl:value-of select="name(.)"/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:variable>-->

                    <xsl:variable name="externalVar"
                        select="$States/win-def:auditeventpolicy_state[@id=$state]/child::node()/@var_ref"/>
                    <xsl:variable name="operation"
                        select="$States/win-def:auditeventpolicy_state[@id=$state]/child::node()/@operation"/>
                    <xsl:variable name="datatype"
                        select="$States/win-def:auditeventpolicy_state[@id=$state]/child::node()/@datatype"/>

                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>
                        <!--<xsl:attribute name="auditpolicy_parameter">
                            <xsl:value-of select="$auditpolicy_parameter"/>
                        </xsl:attribute>-->
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>auditevent</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>

                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>

        </xsl:variable>

        <xsl:variable name="preCoditionStatus">
            <xsl:choose>
                <xsl:when
                    test="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id != '' ">
                    <xsl:variable name="test"
                        select="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id"/>
                    <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/@result"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:if test=" $preCoditionStatus = 'true' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='auditevent' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"></xsl:variable>
                    
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated'  or  @result='true' ] ">

                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:for-each select="$SystemData/win-sc:auditeventpolicy_item[@id=$itemRef]/*">
                            
                            <xsl:variable name="auditpolicy_parameter" select="name(.)"/>
                            
                            <xsl:variable name="actualParameterValue" select="text()"/>
                            <xsl:variable name="actualParameterStatus">
                                <xsl:if test="$actualParameterValue = '' ">
                                    <xsl:text>does not exist</xsl:text>
                                </xsl:if>
                            </xsl:variable>
                            
                            <xsl:variable name="externalVarId">
                                <xsl:for-each select="$States/win-def:auditeventpolicy_state[@id=$state]/*">
                                    <xsl:if test="name(.) = $auditpolicy_parameter">
                                        <xsl:value-of select="@var_ref"/>
                                    </xsl:if>
                                </xsl:for-each>
                            </xsl:variable>                                                                                                                    
                            <xsl:variable name="externalVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                            
                            <xsl:variable name="message_id">
                                <xsl:call-template name="getMessageId">
                                    <xsl:with-param name="eventname" select="$auditpolicy_parameter"/>
                                </xsl:call-template>
                            </xsl:variable>
                            
                            <xsl:if test="$message_id != ''  and $actualParameterValue != $externalVarValue and $result != 'true' " >
                                <finding messageId="{$message_id}" isViolation="true">
                                    <instanceValue key="inputAuditType">
                                        <xsl:call-template name="auditString">
                                            <xsl:with-param name="auditType" select="$externalVarValue"/>
                                        </xsl:call-template>
                                    </instanceValue>
                                    <actualValue key="actualAuditType">
                                        <xsl:call-template name="auditString">
                                            <xsl:with-param name="auditType" select="$actualParameterValue"/>
                                        </xsl:call-template>
                                    </actualValue>
                                </finding>                           
                            </xsl:if>
                            
                            <xsl:if test="$message_id != '' and $actualParameterValue = $externalVarValue  and $result = 'true' " >
                                <finding messageId="{$message_id}" isViolation="false">
                                    <instanceValue key="inputAuditType">
                                        <xsl:call-template name="auditString">
                                            <xsl:with-param name="auditType" select="$externalVarValue"/>
                                        </xsl:call-template>
                                    </instanceValue>
                                    <actualValue key="actualAuditType">
                                        <xsl:call-template name="auditString">
                                            <xsl:with-param name="auditType" select="$actualParameterValue"/>
                                        </xsl:call-template>
                                    </actualValue>
                                </finding>                           
                            </xsl:if>                           
                            
                        </xsl:for-each>
                                                                                               
                    </xsl:for-each>
                </xsl:for-each>
            </findings>
        </xsl:if>

    </xsl:template>
</xsl:stylesheet>